$( 'document' ).ready( function () {

  burgerButton.init();
  accordeon.init();
  bookmarkButton.init();
  customJobTypes.init( $('#search_categories') );
  woocommerceLoginScreen.init();

  // Temporary here
  ( function () {

    if ( $('.page-template-CV').length == 0 ) {
      return;
    }
    $('.file-upload-wrapper .custom-file-upload-hidden').on("change", function () {
      console.log( $(this).parent().find('.file-upload-input') );
      $(this).parent().find('.file-upload-input').addClass('is-showed');
    })

  } )();

  // Michael
  $( ".logo-slider" ).slick({
    centerMode: true,
    centerPadding: '0',
    slidesToShow: 3,
    slidesToScroll: 3,
    dots: true,
    arrows: false,
  });

  $('select').each(function(){
    var $this = $(this), numberOfOptions = $(this).children('option').length;

    $this.addClass('select-hidden');
    $this.wrap('<div class="select"></div>');
    $this.after('<div class="select-styled"></div>');

    var $styledSelect = $this.next('div.select-styled');
    $styledSelect.text($this.children('option').eq(0).text());

    var $list = $('<ul />', {
        'class': 'select-options'
    }).insertAfter($styledSelect);

    for (var i = 0; i < numberOfOptions; i++) {
        $('<li />', {
            text: $this.children('option').eq(i).text(),
            rel: $this.children('option').eq(i).val()
        }).appendTo($list);
    }

    var $listItems = $list.children('li');

    $styledSelect.click(function(e) {
        e.stopPropagation();
        $('div.select-styled.active').not(this).each(function(){
            $(this).removeClass('active').next('ul.select-options').hide();
        });
        $(this).toggleClass('active').next('ul.select-options').toggle();
    });

    $listItems.click(function(e) {
        e.stopPropagation();
        $styledSelect.text($(this).text()).removeClass('active');
        $this.val($(this).attr('rel'));
        $list.hide();
        //console.log($this.val());
    });

    $(document).click(function() {
        $styledSelect.removeClass('active');
        $list.hide();
    });

  });
} );

const woocommerceLoginScreen = {
  init: function () {

    this.redirectBehavior();
    $('.jobify-registration-role-wrapper').parent().addClass('is-hidden');
    this.defaultRoleInit();
    // $('#screen-login .button-empty').on('click', this.showRegistration);
    // $('#screen-registration .button-empty').on('click', this.showLogin);
    $('.l-login .js-role-btn').on('click', this.chooseRole);

  },

  redirectBehavior: function () {
    if ( jobifySettings.pages.current == 'sign-up' ) {
      $('#screen-registration').addClass('is-current');
    } else {
      $('#screen-login').addClass('is-current');
    }
    console.log( jobifySettings.pages.current );
  },

  showRegistration: function (e) {
    e.preventDefault();
    $('#screen-login').fadeOut( 400, function () {
      $('#screen-registration').fadeIn();
    } );
  },

  showLogin: function (e) {
    e.preventDefault();
    $('#screen-registration').fadeOut( 400, function () {
      $('#screen-login').fadeIn();
    } );
  },

  defaultRoleInit: function () {
    let def_role = $(`.l-login .jobify-registration-role option:selected`).val();
    $(`.js-role-btn[data-role=${def_role}]`).addClass('is-active');
  },

  chooseRole: function (e) {

    e.preventDefault();
    $(e.target).siblings().removeClass('is-active');
    $(e.target).addClass('is-active');

    let role = $(e.target).data('role');
    $(`.l-login .jobify-registration-role option[value=${role}]`).prop('selected', true);
    console.log( $('.l-login .jobify-registration-role option:selected').val() );
  }

};

const customJobTypes = {

  init: function ( selector ) {
    this.target_select = $(selector);
    this.handleClick();
    this.options();
  },

  handleClick: function () {
    $('.js-custom-select').on('click', function ( e ) {

      $(this).addClass('is-opened');
      $('.js-custom-select .dropdown').slideToggle();

      if ( $(e.target).hasClass('dropdown-item') ) {
        changeSelected( e.target );
      }

    })
  },

  options: function () {
    this.target_select.find('option').each( function ( i, el ) {

      let list_item = $("<li></li>")
        .text( $(el).text() )
        .addClass("dropdown-item")
        .attr( "data-value", $(el).val() );

      $('.js-custom-select .dropdown').append( list_item );

    } );
  },

  changeSelected: function ( li ) {
    $('.js-custom-select .selected-value').text( $(li).text() );
  }

};

const bookmarkButton = {

  init: function () {
    this.handleClick();
  },

  handleClick: function () {
    $('.js-bookmark-job').on('click', function (e) {
      e.preventDefault();
      var bookmarkURL = window.location.href;
      var bookmarkTitle = document.title;

      if ('addToHomescreen' in window && addToHomescreen.isCompatible) {
        // Mobile browsers
        addToHomescreen({ autostart: false, startDelay: 0 }).show(true);
      } else if (window.sidebar && window.sidebar.addPanel) {
        // Firefox <=22
        window.sidebar.addPanel(bookmarkTitle, bookmarkURL, '');
      } else if ((window.sidebar && /Firefox/i.test(navigator.userAgent)) || (window.opera && window.print)) {
        // Firefox 23+ and Opera <=14
        $(this).attr({
          href: bookmarkURL,
          title: bookmarkTitle,
          rel: 'sidebar'
        }).off(e);
        return true;
      } else if (window.external && ('AddFavorite' in window.external)) {
        // IE Favorites
        window.external.AddFavorite(bookmarkURL, bookmarkTitle);
      } else {
        // Other browsers (mainly WebKit & Blink - Safari, Chrome, Opera 15+)
        alert('Press ' + (/Mac/i.test(navigator.platform) ? 'Cmd' : 'Ctrl') + '+D to bookmark this page.');
      }
      return false;
    })
  }

};

const burgerButton = {

  init: function () {
    this.handleClick();
  },

  handleClick: function () {
    $('.js-burger-button').on('click', function () {
      $(this).toggleClass('is-opened');
      $('.header-menu__mobile').toggleClass('is-opened');
    });

    $('.header-menu__mobile .menu-item-has-children').on('click', function () {
      $(this).toggleClass('is-opened');
    });
  }

};

const accordeon = {

  init: function () {
    this.handleClick();
  },

  handleClick: function () {
    $('.js-accordeon').on('click', function () {
      $(this).toggleClass('is-opened');
      $(this).find('.c-accordeon__content').slideToggle();
    })
  }

};

(function($) {

		  // Browser supports HTML5 multiple file?
		  var multipleSupport = typeof $('<input/>')[0].multiple !== 'undefined',
		      isIE = /msie/i.test( navigator.userAgent );

		  $.fn.customFile = function() {

		    return this.each(function() {

		      var $file = $(this).addClass('custom-file-upload-hidden'), // the original file input
		          $wrap = $('<div class="file-upload-wrapper">'),
		          $input = $('<input type="text" class="file-upload-input" />'),
		          // Button that will be used in non-IE browsers
		          $button = $('<button type="button" class="file-upload-button">Choose image</button>'),
		          // Hack for IE
		          $label = $('<label class="file-upload-button" for="'+ $file[0].id +'">Choose image</label>');

		      // Hide by shifting to the left so we
		      // can still trigger events
		      $file.css({
		        position: 'absolute',
		        left: '-9999px'
		      });

		      $wrap.insertAfter( $file )
		        .append( $file, $input, ( isIE ? $label : $button ) );

		      // Prevent focus
		      $file.attr('tabIndex', -1);
		      $button.attr('tabIndex', -1);

		      $button.click(function () {
		        $file.focus().click(); // Open dialog
		      });

		      $file.change(function() {

		        var files = [], fileArr, filename;

		        // If multiple is supported then extract
		        // all filenames from the file array
		        if ( multipleSupport ) {
		          fileArr = $file[0].files;
		          for ( var i = 0, len = fileArr.length; i < len; i++ ) {
		            files.push( fileArr[i].name );
		          }
		          filename = files.join(', ');

		        // If not supported then just take the value
		        // and remove the path to just show the filename
		        } else {
		          filename = $file.val().split('\\').pop();
		        }

		        $input.val( filename ) // Set the value
		          .attr('title', filename) // Show filename in title tootlip
		          .focus(); // Regain focus

		      });

		      $input.on({
		        blur: function() { $file.trigger('blur'); },
		        keydown: function( e ) {
		          if ( e.which === 13 ) { // Enter
		            if ( !isIE ) { $file.trigger('click'); }
		          } else if ( e.which === 8 || e.which === 46 ) { // Backspace & Del
		            // On some browsers the value is read-only
		            // with this trick we remove the old input and add
		            // a clean clone with all the original events attached
		            $file.replaceWith( $file = $file.clone( true ) );
		            $file.trigger('change');
		            $input.val('');
		          } else if ( e.which === 9 ){ // TAB
		            return;
		          } else { // All other keys
		            return false;
		          }
		        }
		      });

		    });

		  };

		  // Old browser fallback
		  if ( !multipleSupport ) {
		    $( document ).on('change', 'input.customfile', function() {

		      var $this = $(this),
		          // Create a unique ID so we
		          // can attach the label to the input
		          uniqId = 'customfile_'+ (new Date()).getTime(),
		          $wrap = $this.parent(),

		          // Filter empty input
		          $inputs = $wrap.siblings().find('.file-upload-input')
		            .filter(function(){ return !this.value }),

		          $file = $('<input type="file" id="'+ uniqId +'" name="'+ $this.attr('name') +'"/>');

		      // 1ms timeout so it runs after all other events
		      // that modify the value have triggered
		      setTimeout(function() {
		        // Add a new input
		        if ( $this.val() ) {
		          // Check for empty fields to prevent
		          // creating new inputs when changing files
		          if ( !$inputs.length ) {
		            $wrap.after( $file );
		            $file.customFile();
		          }
		        // Remove and reorganize inputs
		        } else {
		          $inputs.parent().remove();
		          // Move the input so it's always last on the list
		          $wrap.appendTo( $wrap.parent() );
		          $wrap.find('input').focus();
		        }
		      }, 1);

		    });
		  }

      $('#featured_image').change(function () {

             var input = $(this)[0];
             if (input.files && input.files[0]) {
                 if (input.files[0].type.match('image.*')) {
                     var reader = new FileReader();
                     reader.onload = function (e) {
                         $('label[for="featured_image"] .job-manager-uploaded-files').html(`<div class="job-manager-uploaded-file">
			<span class="job-manager-uploaded-file-preview"><img src="${e.target.result}"> <a class="job-manager-remove-uploaded-file" href="#">[remove]</a></span>


</div>`);
    //  console.log( e.target.result);
                     }
                     reader.readAsDataURL(input.files[0]);
                 } else {
                     console.log('ошибка, не изображение');
                 }
             } else {

             }
         });
         $('#company_logo').change(function () {

                var input = $(this)[0];
                if (input.files && input.files[0]) {
                    if (input.files[0].type.match('image.*')) {
                        var reader = new FileReader();
                        reader.onload = function (e) {
                            $('label[for="company_logo"] .job-manager-uploaded-files').html(`<div class="job-manager-uploaded-file">
         <span class="job-manager-uploaded-file-preview"><img src="${e.target.result}"> <a class="job-manager-remove-uploaded-file" href="#">[remove]</a></span>


       </div>`);
       //  console.log( e.target.result);
                        }
                        reader.readAsDataURL(input.files[0]);
                    } else {
                        console.log('ошибка, не изображение');
                    }
                } else {

                }
            });

            $('#candidate_photo').change(function () {

                   var input = $(this)[0];
                   if (input.files && input.files[0]) {
                       if (input.files[0].type.match('image.*')) {
                           var reader = new FileReader();
                           reader.onload = function (e) {
                               $('label[for="candidate_photo"] .job-manager-uploaded-files').html(`<div class="job-manager-uploaded-file">
            <span class="job-manager-uploaded-file-preview"><img src="${e.target.result}"> <a class="job-manager-remove-uploaded-file" href="#">[remove]</a></span>


            </div>`);
            //  console.log( e.target.result);
                           }
                           reader.readAsDataURL(input.files[0]);
                       } else {
                           console.log('ошибка, не изображение');
                       }
                   } else {

                   }
               });


            $('#resume_file').change(function () {

                            var input = $(this)[0];
                            if (input.files && input.files[0]) {
                                if (input.files[0].type.match('image.*')) {
                                    var reader = new FileReader();
                                    reader.onload = function (e) {
                                        $('label[for="resume_file"] .job-manager-uploaded-files').html(`<div class="job-manager-uploaded-file">
                     <span class="job-manager-uploaded-file-preview"><img src="${e.target.result}"> <a class="job-manager-remove-uploaded-file" href="#">[remove]</a></span>


                   </div>`);
                   //  console.log( e.target.result);
                                    }
                                    reader.readAsDataURL(input.files[0]);
                                } else {
             $('label[for="resume_file"] .job-manager-uploaded-files').html(`<div class="job-manager-uploaded-file">
                     <span class="job-manager-uploaded-file-preview"><div>${input.files[0].name}</div> <a class="job-manager-remove-uploaded-file" href="#">[remove]</a></span>


                   </div>`);
                                    console.log(input.files[0].name);
                                }
                            } else {

                            }
                        });

}(jQuery));
$('input[type=file]').customFile();
