<?php
/**
 * @version 2:0.9.5
 * @property-read string $id_obmenka Cashbox ID
 * @property-read string $oikk   ubj  Secret key
 * @property-read array $currency transaction currency
 * @property-read bool $test_mode is testing mode
 */
class obmenkaPayment extends waPayment
{
    public $url_payment = 'https://acquiring.obmenka.ua/acs';



    const ikUrlSCI = 'https://acquiring.obmenka.ua/acs';



    public function allowedCurrency()
    {
        return (is_string($this->currency) ? $this->currency : array_keys(array_filter($this->currency)));
    }

    public static function availableCurrency()
    {
        $allowed = array(
            'EUR',
            'USD',
            'UAH',
            'RUB',
            'BYR',
            'XAU', //Золото (одна тройская унция)

        );

        $available = array();
        $app_config = wa()->getConfig();
        if (method_exists($app_config, 'getCurrencies'))
        {
            $currencies = $app_config->getCurrencies();
            foreach ($currencies as $code => $c)
            {
                if (in_array($code, $allowed))
                {
                    $available[] = array(
                        'value' => $code,
                        'title' => sprintf('%s %s', $c['code'], $c['title']) ,
                        'description' => $c['sign'],
                    );
                }
            }
        }
        return $available;
    }

    public function payment($payment_form_data, $order_data, $auto_submit = false)
    {
        $order = waOrder::factory($order_data);

        if ($order->currency == 'RUB')
        {
            $order->currency = 'RUR';
        }

        $secret = $this->secret_key_obmenka;

        $FormData = [
          'CLIENT_ID' => $this->id_obmenka,
          'INVOICE_ID' => $order->id,
          'AMOUNT' => number_format($order->total, 2, '.', '') ,
          'CURRENCY' => $order->currency,
        //'PAYMENT_CURRENCY' => 'qiwi',
          'DESCRIPTION' => 'Оплата заказа #' . $order->id,
          'SUCCESS_URL' => 'https://' . $_SERVER['SERVER_NAME'] . '/payments.php/obmenka/?result=success&order=' . $order->id,
          'FAIL_URL' => 'https://' . $_SERVER['SERVER_NAME'] . '/checkout/fail/',
          'STATUS_URL' => $this->getAdapter()
            ->getBackUrl(waAppPayment::URL_SUCCESS) ];

        $sign = base64_encode(md5($secret . base64_encode(sha1(implode('', $FormData) , true)) . $secret, true));

        $FormData['SIGN_ORDER'] = implode(';', array_keys($FormData));
        $FormData['SIGN'] = $sign;

        $view = wa()->getView();
        $view->assign('hidden_fields', $FormData);
        $view->assign('url_request', $this->getRelayUrl() . '?paysys');
        $view->assign('auto_submit', $auto_submit);
        $view->assign('obmenka', $this);
        $view->assign('path_modal_tpl', $this->path . '/templates/modal_ps.tpl');

        return $view->fetch($this->path . '/templates/payment.tpl');
    }


    protected function callbackHandler($request)
    {



        $FormData = ['payment_id' => $request['order'],

        ];

        include_once dirname(dirname(dirname(dirname(dirname(__FILE__))))) . "/wa-apps/shop/lib/model/shopPluginSettings.model.php";

        $shop_plugin = new shopPluginSettingsModel();
        $id = $shop_plugin->get('id_obmenka_this');
        foreach ($id as $key ) {
          if ($key['name'] == 'id_obmenka') {
            $id_obmennka = $key['value'];
          }
          if ($key['name'] == 'secret_key_obmenka') {
            $secret = $key['value'];
          }
        }


        $data = json_encode($FormData);
        $sign = base64_encode(md5($secret . base64_encode(sha1($data, true)) . $secret, true));

        $headers = array(
            'DPAY_SECURE: ' . $sign,
            'DPAY_CLIENT: ' . $id_obmennka,
            'Content-type: application/json',

        );

        $url = "https://acquiring_api.obmenka.ua/api/einvoice/status";

        $post_data = array(
            "payment_id" => $request['order']
        );
        $post_data = json_encode($post_data);
        $FormData = json_encode($FormData);
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $FormData);

        $output = curl_exec($ch);

        curl_close($ch);

        $unswer = json_decode($output);

        include_once dirname(dirname(dirname(dirname(dirname(__FILE__))))) . "/wa-apps/shop/lib/model/shopOrder.model.php";




        if ($unswer->status == 'FAILED')
        {
          $URL_redirect = 'https://' . $_SERVER['SERVER_NAME'] . 'payments.php/obmenka/?result=fail';
        }
        else if ($unswer->status == 'FINISHED')
        {
            $order_model = new shopOrderModel();

            $data = array(
                'state_id' => 'paid',
            );
            $order_model->updateById($request['order'], $data);
            $URL_redirect = 'https://' . $_SERVER['SERVER_NAME'] . '/checkout/success/?order_id= ' . $request['order'];
        }
        else if ($unswer->status == 'CANCELED')
        {
            $URL_redirect = 'https://' . $_SERVER['SERVER_NAME'] . '/checkout/fail/';
        }
        else if ($unswer->status == 'PAYIN_ERROR ')
        {
            $URL_redirect = 'https://' . $_SERVER['SERVER_NAME'] . '/checkout/fail/';
        }
        else
        {
            $URL_redirect = 'https://' . $_SERVER['SERVER_NAME'] . '/checkout/fail/';
        }


        return array(
            'redirect' => $URL_redirect, //требуемый URL, на который нужно перенаправить покупателя

        );
    }



}
