<?php
/*
Plugin Name: WooCommerce - Obmenka
Description: Obmenka Payment Gateway for WooCommerce.
Version: 1.0
Author: support@obmenka.ua
Author URI: http://obmenka.ua/
License: GNU General Public License v3.0
License URI: http://www.gnu.org/licenses/gpl-3.0.html
*/

add_action('plugins_loaded', 'woocommerce_obmenka_init', 0);
define('IMGDIR', WP_PLUGIN_URL . "/" . plugin_basename(dirname(__FILE__)) . '/assets/img/');

function woocommerce_obmenka_init()
{
    if (!class_exists('WC_Payment_Gateway')) {
        return;
    }

    if (isset($_GET['msg']) && !empty($_GET['msg'])) {
        add_action('the_content', 'showObmenkaMessage');
    }
    function showObmenkaMessage($content)
    {
        return '<div class="' . htmlentities($_GET['type']) . '">' . htmlentities(urldecode($_GET['msg'])) . '</div>' . $content;
    }

    /**
     * Gateway class
     */
    class WC_obmenka extends WC_Payment_Gateway
    {
        protected $url = 'https://acquiring.obmenka.ua/acs';

        const ORDER_APPROVED = 'Approved';
        const SIGNATURE_SEPARATOR = ';';
        const ORDER_SEPARATOR = ":";
        const ORDER_SUFFIX = '_woo_w4p_';

        protected $keysForResponseSignature = array(
            'merchantAccount',
            'orderReference',
            'amount',
            'currency',
            'authCode',
            'cardPan',
            'transactionStatus',
            'reasonCode'
        );

        /** @var array */
        protected $keysForSignature = array(
            'merchantAccount',
            'merchantDomainName',
            'orderReference',
            'orderDate',
            'amount',
            'currency',
            'productName',
            'productCount',
            'productPrice'
        );


        public function __construct()
        {
            $this->id = 'obmenka';
            $this->method_title = 'Obmenka';
            $this->method_description = "Payment gateway";
            $this->has_fields = false;
            $this->init_form_fields();
            $this->init_settings();
            if ($this->settings['showlogo'] == "yes") {
                $this->icon = IMGDIR . 'logo.png';
            }
            $this->title = $this->settings['title'];
            $this->redirect_page_id = $this->settings['returnUrl'];
               $this->redirect_page_idfailUrl = $this->settings['failUrl'];



            $this->serviceUrl = $this->settings['returnUrl'];

            $this->merchant_id = $this->settings['merchant_account'];
            $this->secretKey = $this->settings['secret_key'];
            $this->description = $this->settings['description'];

            $this->msg['message'] = "";
            $this->msg['class'] = "";

            if (version_compare(WOOCOMMERCE_VERSION, '2.0.0', '>=')) {
                /* 2.0.0 */
                add_action('woocommerce_api_' . strtolower(get_class($this)), array($this, 'check_obmenka_response'));
                add_action('woocommerce_update_options_payment_gateways_' . $this->id, array($this, 'process_admin_options'));
            } else {
                /* 1.6.6 */
                add_action('init', array(&$this, 'check_obmenka_response'));
                add_action('woocommerce_update_options_payment_gateways', array(&$this, 'process_admin_options'));
            }

            add_action('woocommerce_receipt_obmenka', array(&$this, 'receipt_page'));
        }

        function init_form_fields()
        {
            $this->form_fields = array('enabled' => array('title' => __('Enable/Disable', 'kdc'),
                'type' => 'checkbox',
                'label' => __('Enable Obmenka Payment Module.', 'kdc'),
                'default' => 'no',
                'description' => 'Show in the Payment List as a payment option'),
                'title' => array('title' => __('Title:', 'kdc'),
                    'type' => 'text',
                    'default' => __('Obmenka Payments', 'kdc'),
                    'description' => __('This controls the title which the user sees during checkout.', 'kdc'),
                    'desc_tip' => true),
                'description' => array('title' => __('Description:', 'kdc'),
                    'type' => 'textarea',
                    'default' => __('Pay securely by Credit or Debit Card or Internet Banking through Obmenka.ua service.', 'kdc'),
                    'description' => __('This controls the description which the user sees during checkout.', 'kdc'),
                    'desc_tip' => true),
                'merchant_account' => array('title' => __('Client ID', 'kdc'),
                    'type' => 'text',
                    'description' => __('Given to Merchant by Obmenka.ua'),
                    'default' => 'test_merch_n1',
                    'desc_tip' => true
                ),
                'secret_key' => array('title' => __('Merchant secret', 'kdc'),
                    'type' => 'text',
                    'description' => __('Given to Merchant by Obmenka.ua', 'kdc'),
                    'desc_tip' => true,
                    'default' => 'flk3409refn54t54t*FNJRET',
                ),
                'showlogo' => array('title' => __('Show Logo', 'kdc'),
                    'type' => 'checkbox',
                    'label' => __('Show the "Obmenka.ua" logo in the Payment Method section for the user', 'kdc'),
                    'default' => 'yes',
                    'description' => __('Tick to show "Obmenka.ua" logo'),
                    'desc_tip' => true)

                    // 'serviceUrl' => array('title' => __('Service URL'),
                    //     'options' => $this->obmenka_get_pages('Select Page'),
                    //     'type' => 'select',
                    //     'description' => __('URL with result of transaction page', 'kdc'),
                    //     'desc_tip' => true)
                // 'returnUrl' => array('title' => __('Success URL'),
                //     'type' => 'select',
                //     'options' => $this->obmenka_get_pages('Select Page'),
                //     'description' => __('URL of success page', 'kdc'),
                //     'desc_tip' => true),
                // 'returnUrl_m' => array('title' => __('или укажите'),
                //     'type' => 'text',
                //     'description' => __('URL of success page', 'kdc'),
                //     'default' => '',
                //     'desc_tip' => true
                // ),
                //   'failUrl' => array('title' => __('Fail URL'),
                //     'type' => 'select',
                //     'options' => $this->obmenka_get_pages('Select Page'),
                //     'description' => __('URL of fail page', 'kdc'),
                //     'desc_tip' => true),
                // 'failUrl_m' => array('title' => __('или укажите'),
                //     'type' => 'text',
                //     'description' => __('URL of fail page', 'kdc'),
                //     'default' => '',
                //     'desc_tip' => true
                // ),
                // 'serviceUrl' => array('title' => __('Service URL'),
                //     'options' => $this->obmenka_get_pages('Select Page'),
                //     'type' => 'select',
                //     'description' => __('URL with result of transaction page', 'kdc'),
                //     'desc_tip' => true)
            );
        }

        /**
         * Admin Panel Options
         * - Options for bits like 'title' and availability on a country-by-country basis
         **/
        public function admin_options()
        {
            echo '<h3>' . __('Obmenka.ua', 'kdc') . '</h3>';
            echo '<p>' . __('Payment gateway') . '</p>';
            echo '<table class="form-table">';
            // Generate the HTML For the settings form.
            $this->generate_settings_html();
            echo '</table>';
        }

        /**
         *  There are no payment fields for techpro, but we want to show the description if set.
         **/
        function payment_fields()
        {
            if ($this->description) {
                echo wpautop(wptexturize($this->description));
            }
        }

        /**
         * Receipt Page
         **/
        function receipt_page($order)
        {
            global $woocommerce;

            echo '<p>' . __('Спасибо за ваш заказ, сейчас вы будете перенаправлены на страницу оплаты Obmenka.', 'kdc') . '</p>';
            echo $this->generate_obmenka_form($order);

            $woocommerce->cart->empty_cart();
        }

        /**
         * @param $options
         * @return string
         */
        public function getRequestSignature($options)
        {
            return $this->getSignature($options, $this->keysForSignature);
        }

        /**
         * @param $options
         * @return string
         */
        public function getResponseSignature($options)
        {
            return $this->getSignature($options, $this->keysForResponseSignature);
        }

        /**
         * @param $option
         * @param $keys
         * @param $hashOnly
         * @return string
         */
        public function getSignature($option, $keys, $hashOnly = false)
        {
            $hash = array();
            foreach ($keys as $dataKey) {
                if (!isset($option[$dataKey])) {
                    continue;
                }
                if (is_array($option[$dataKey])) {
                    foreach ($option[$dataKey] as $v) {
                        $hash[] = $v;
                    }
                } else {
                    $hash [] = $option[$dataKey];
                }
            }
            $hash = implode(';', $hash);
            if ($hashOnly) {
		return base64_encode($hash);
	    } else {
                return hash_hmac('md5', $hash, $this->secretKey);
	    }
        }

        /**
         * @return $this
         */
        public function fillPayForm($data)
        {
        $secret =  $this->secretKey;
            $data['CLIENT_ID'] = $this->merchant_id;
           $sign = base64_encode(md5($secret . base64_encode(sha1(implode('', $data), true)) . $secret, true));

$data['SIGN_ORDER'] = implode(';', array_keys($data));
$data['SIGN'] = $sign;


            return $this->generateForm($data);
        }


        /**
         * Generate form with fields
         *
         * @param $data
         * @return string
         */
        protected function generateForm($data)
        {
            $form = '<form method="post" id="form_obmenka" action="' . $this->url . '" accept-charset="utf-8">';
            foreach ($data as $k => $v) $form .= $this->printInput($k, $v);
            $button = "<img style='position:absolute; top:50%; left:47%; margin-top:-125px; margin-left:-60px;' src='$img' >
	<script>
		function submitObmenkaForm()
		{
			document.getElementById('form_obmenka').submit();
		}
		setTimeout( submitObmenkaForm, 200 );
	</script>";

            return $form .
            "<input type='submit' style='display:none;' /></form>"
            . $button;
        }

        /**
         * Print inputs in form
         *
         * @param $name
         * @param $val
         * @return string
         */
        protected function printInput($name, $val)
        {
            $str = "";
            if (!is_array($val)) return '<input type="hidden" name="' . $name . '" value="' . htmlspecialchars($val) . '">' . "\n<br />";
            foreach ($val as $v) $str .= $this->printInput($name . '[]', $v);
            return $str;
        }


        /**
         * @param $inputData
         * @return mixed|string|void
         */
        public function checkResponse($inputData)
        {
            global $wpdb;
            $ref = $inputData['orderReference'];
            $sessID = explode("_", $ref);
            $sessionId = $sessID[1];

            $sign = $this->getResponseSignature($inputData);
            if (!empty($inputData["merchantSignature"]) && $inputData["merchantSignature"] == $sign) {
                if ($inputData['transactionStatus'] == self::ORDER_APPROVED) {

                    $notes = "Obmenka : orderReference:" . $inputData['transactionStatus'] . " \n\n recToken: " . $inputData['recToken'];

                    $data = array(
                        'processed' => 3,
                        'transactid' => $ref,
                        'date' => time(),
                        'notes' => $notes
                    );


                    $where = array('transactid' => $ref);
                    $format = array('%d', '%s', '%s', '%s');
                    $wpdb->update(WPSC_TABLE_PURCHASE_LOGS, $data, $where, $format);
                    transaction_results($sessionId, false, $ref);
                    return $this->getAnswerToGateWay($inputData);
                }

            }
            return null;

        }


        /**
         * @param $data
         * @return mixed|string|void
         */
        public function getAnswerToGateWay($data)
        {
            $time = time();
            $responseToGateway = array(
                'orderReference' => $data['orderReference'],
                'status' => 'accept',
                'time' => $time
            );
            $sign = array();
            foreach ($responseToGateway as $dataKey => $dataValue) {
                $sign [] = $dataValue;
            }
            $sign = implode(';', $sign);
            $sign = hash_hmac('md5', $sign, $this->secretKey);
            $responseToGateway['signature'] = $sign;

            return json_encode($responseToGateway);
        }


        /**
         * Generate obmenka button link
         **/
        function generate_obmenka_form($order_id)
        {
            $order = new WC_Order($order_id);

            $orderDate = isset($order->post->post_date)? $order->post->post_date : $order->order_date;

            $currency = str_replace(
            	array('ГРН','uah','RUB','РУБ'),
            	array('UAH','UAH','RUR','RUR'),
            	get_woocommerce_currency()
    	    );

            $obmenka_args = array(
                'INVOICE_ID' => $order_id,
                'CURRENCY' =>  $currency,
                'AMOUNT' => $order->get_total(),
                'SUCCESS_URL' => get_site_url().'/?wc-api=WC_obmenka&id='.$order_id.'&url='.get_site_url().'&status=suc',
                'FAIL_URL' => get_site_url().'/?wc-api=WC_obmenka&id='.$order_id.'&url='.get_site_url().'&status=fail',
                'STATUS_URL' => get_site_url().'/?wc-api=WC_obmenka&id='.$order_id.'&url='.get_site_url().'&status=status'

            );
            // 'PAYMENT_CURRENCY' => 'qiwi'


          //  $obmenka_args = array_merge($obmenka_args, $client);

            return $this->fillPayForm($obmenka_args);
        }

        /**
         * Process the payment and return the result
         **/
        function process_payment($order_id)
        {
            $order = new WC_Order($order_id);

            if (version_compare(WOOCOMMERCE_VERSION, '2.1.0', '>=')) {
                /* 2.1.0 */
                $checkout_payment_url = $order->get_checkout_payment_url(true);
            } else {
                /* 2.0.0 */
                $checkout_payment_url = get_permalink(get_option('woocommerce_pay_page_id'));
            }

            return array('result' => 'success',
                'redirect' => add_query_arg('order', $order->id, add_query_arg('key', $order->order_key, $checkout_payment_url)));
        }

        /**
         * @param bool $service
         * @return bool|string
         */
          private function getfailUrl(){
          $service==false;
            $redirect_url = ($this->redirect_page_idfailUrl == "" || $this->redirect_page_idfailUrl == 0) ? get_site_url() . "/" : get_permalink($this->redirect_page_idfailUrl);
            if (!$service) {
		if (
		    isset($this->settings['failUrl_m']) &&
		    trim($this->settings['failUrl_m']) !== ''
	   	) {
		    return trim($this->settings['failUrl_m']);
		}
                return $redirect_url;
            }

            return add_query_arg('wc-api', get_class($this), $redirect_url);

          }
        private function getCallbackUrl($service = false)
        {

            $redirect_url = ($this->redirect_page_id == "" || $this->redirect_page_id == 0) ? get_site_url() . "/" : get_permalink($this->redirect_page_id);
            if (!$service) {
		if (
		    isset($this->settings['returnUrl_m']) &&
		    trim($this->settings['returnUrl_m']) !== ''
	   	) {
		    return trim($this->settings['returnUrl_m']);
		}
                return $redirect_url;
            }

            return add_query_arg('wc-api', get_class($this), $redirect_url);
        }

        private function getLanguage()
        {
            return substr(get_bloginfo('language'), 0, 2);
        }


        protected function isPaymentValid($response)
        {
            global $woocommerce;

            list($orderId,) = explode(self::ORDER_SUFFIX, $response['orderReference']);
            $order = new WC_Order($orderId);
            if ($order === FALSE) {
                return 'An error has occurred during payment. Please contact us to ensure your order has submitted.';
            }

            if ($this->merchant_id != $response['merchantAccount']) {
                return 'An error has occurred during payment. Merchant data is incorrect.';
            }

            $responseSignature = $response['merchantSignature'];


            if ($this->getResponseSignature($response) != $responseSignature) {
                die('An error has occurred during payment. Signature is not valid.');
            }

            if ($response['transactionStatus'] == self::ORDER_APPROVED) {

                $order->update_status('processing');
                $order->payment_complete();
                $order->add_order_note('Obmenka.ua payment successful.<br/>Obmenka.ua ID: ' . ' (' . $_REQUEST['payment_id'] . ')');
                return true;
            }

            $woocommerce->cart->empty_cart();

            return false;
        }

        /**
         * Check response on service url
         */
        function check_obmenka_response($id)
        {
            $data = json_decode(file_get_contents("php://input"), true);
          /*  $paymentInfo = $this->isPaymentValid($data);
            if ($paymentInfo === true) {
                echo $this->getAnswerToGateWay($data);

                $this->msg['message'] = "Thank you for shopping with us. Your account has been charged and your transaction is successful.";
                $this->msg['class'] = 'woocommerce-message';
            }
            exit;
            */


             global $woocommerce;






      // if ($_REQUEST['status'] == 'suc')  {




         $FormData = ['payment_id' => $_REQUEST['id'],

         ];



         $data = json_encode($FormData);
         $sign = base64_encode(md5($this->secretKey . base64_encode(sha1($data, true)) . $this->secretKey, true));

         $headers = array(
             'DPAY_SECURE: ' . $sign,
             'DPAY_CLIENT: ' . $this->merchant_id,
             'Content-type: application/json',

         );

         $url = "https://acquiring_api.obmenka.ua/api/einvoice/status";

         $post_data = array(
             "payment_id" => $_REQUEST['id']
         );
         $post_data = json_encode($post_data);
         $FormData = json_encode($FormData);
         $ch = curl_init();

         curl_setopt($ch, CURLOPT_URL, $url);
         curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
         curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
         curl_setopt($ch, CURLOPT_POST, 1);
         curl_setopt($ch, CURLOPT_POSTFIELDS, $FormData);

         $output = curl_exec($ch);

         curl_close($ch);

         $unswer = json_decode($output);


wp_redirect( $_REQUEST['url'].'/'.$this->merchant_id);





         if ($unswer->status == 'FAILED')
         {
           $order = new WC_Order($_REQUEST['id']);
          $order->update_status('cancelled');
                // $order->payment_complete();
                 $order->add_order_note('Obmenka.ua payment cancelled.<br/>Obmenka.ua ID: ' . ' (' . $_REQUEST['id'] . ')');

                  $woocommerce->cart->empty_cart();
           wp_redirect( $_REQUEST['url'].'/index.php/checkout/order-pay/'.$_REQUEST['id'].'/');
         }
         else if ($unswer->status == 'FINISHED')
         {
           $order = new WC_Order($_REQUEST['id']);


             $order->update_status('processing');
                    $order->payment_complete();
                    $order->add_order_note('Obmenka.ua payment successful.<br/>Obmenka.ua ID: ' . ' (' . $_REQUEST['id'] . ')');

                     $woocommerce->cart->empty_cart();


                      // wp_redirect( $_REQUEST['url'].'/index.php/checkout/order-pay/'.$_REQUEST['id'].'/');
                      wp_redirect( $_REQUEST['url'].'/index.php/checkout/order-received/');

         }
         else if ($unswer->status == 'CANCELED')
         {
           $order = new WC_Order($_REQUEST['id']);
          $order->update_status('cancelled');
                // $order->payment_complete();
                 $order->add_order_note('Obmenka.ua payment cancelled.<br/>Obmenka.ua ID: ' . ' (' . $_REQUEST['id'] . ')');

                  $woocommerce->cart->empty_cart();
           wp_redirect( $_REQUEST['url'].'/index.php/checkout/order-pay/'.$_REQUEST['id'].'/');
         }
         else if ($unswer->status == 'PAYIN_ERROR ')
         {
           $order = new WC_Order($_REQUEST['id']);
          $order->update_status('cancelled');
                // $order->payment_complete();
                 $order->add_order_note('Obmenka.ua payment cancelled.<br/>Obmenka.ua ID: ' . ' (' . $_REQUEST['id'] . ')');

                  $woocommerce->cart->empty_cart();
           wp_redirect( $_REQUEST['url'].'/index.php/checkout/order-pay/'.$_REQUEST['id'].'/');
         }
         else
         {
           $order = new WC_Order($_REQUEST['id']);
          $order->update_status('cancelled');
                // $order->payment_complete();
                 $order->add_order_note('Obmenka.ua payment cancelled.<br/>Obmenka.ua ID: ' . ' (' . $_REQUEST['id'] . ')');

                  $woocommerce->cart->empty_cart();
           wp_redirect( $_REQUEST['url'].'/index.php/checkout/order-pay/'.$_REQUEST['id'].'/');

         }













			 // $order = new WC_Order($_REQUEST['id']);
       //
       //
			 //   $order->update_status('processing');
       //          $order->payment_complete();
       //          $order->add_order_note('Obmenka.ua payment successful.<br/>Obmenka.ua ID: ' . ' (' . $_REQUEST['id'] . ')');
       //
       //           $woocommerce->cart->empty_cart();
       //
       //
       //            // wp_redirect( $_REQUEST['url'].'/index.php/checkout/order-pay/'.$_REQUEST['id'].'/');
       //            wp_redirect( $_REQUEST['url'].'/index.php/checkout/order-received/');
       //
       //      return false;
       //
       //  } else {
       //     $order = new WC_Order($_REQUEST['id']);
       //    $order->update_status('cancelled');
       //          // $order->payment_complete();
       //           $order->add_order_note('Obmenka.ua payment cancelled.<br/>Obmenka.ua ID: ' . ' (' . $_REQUEST['id'] . ')');
       //
       //            $woocommerce->cart->empty_cart();
       //     wp_redirect( $_REQUEST['url'].'/index.php/checkout/order-pay/'.$_REQUEST['id'].'/');
       //  }


        }

        // get all pages
        function obmenka_get_pages($title = false, $indent = true)
        {
            $wp_pages = get_pages('sort_column=menu_order');
            $page_list = array();
            if ($title) {
                $page_list[] = $title;
            }
            foreach ($wp_pages as $page) {
                $prefix = '';
                // show indented child pages?
                if ($indent) {
                    $has_parent = $page->post_parent;
                    while ($has_parent) {
                        $prefix .= ' - ';
                        $next_page = get_page($has_parent);
                        $has_parent = $next_page->post_parent;
                    }
                }
                // add to page list array array
                $page_list[$page->ID] = $prefix . $page->post_title;
            }
            return $page_list;
        }
    }

    /**
     * Add the Gateway to WooCommerce
     **/
    function woocommerce_add_obmenka_gateway($methods)
    {
        $methods[] = 'WC_obmenka';
        return $methods;
    }

    add_filter('woocommerce_payment_gateways', 'woocommerce_add_obmenka_gateway');
}
