<?php

class ModelExtensionPaymentObmenka extends Model {

    public function getMethod($address, $total) {
		
		/* Minimal Order Amount */
		$status = true;
		$minimal = floatval($this->config->get('payment_obmenka_total'));
        if ($minimal > 0) {
			if ($minimal > $total) {
				$status = false;
			}
        }

        $method_data = array();

        if ($status) {
			
			$title = 'ObmenkaUA';
            $names = $this->config->get('payment_obmenka_langdata');
			$lang_id = $this->config->get('config_language_id');
			
            if (!empty($names[$lang_id])) {
				$title = $names[$lang_id]['title'];
			}
			
            $method_data = array(
			
                'code' => 'obmenka',
                'title' => $title,
                'terms' => '',
                'sort_order' => $this->config->get('payment_obmenka_sort_order')
				
            );
			
        }
		
        return $method_data;
		
    }
}